/*
 * Decompiled with CFR 0.152.
 */
package xaero.common.minimap.waypoints;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.class_1074;
import net.minecraft.class_124;
import net.minecraft.class_1657;
import net.minecraft.class_1659;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2558;
import net.minecraft.class_2561;
import net.minecraft.class_2568;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_437;
import net.minecraft.class_5218;
import net.minecraft.class_5250;
import net.minecraft.class_5321;
import net.minecraft.class_634;
import net.minecraft.class_638;
import net.minecraft.class_7924;
import xaero.common.AXaeroMinimap;
import xaero.common.MinimapLogs;
import xaero.common.XaeroMinimapSession;
import xaero.common.minimap.mcworld.MinimapClientWorldData;
import xaero.common.minimap.mcworld.MinimapClientWorldDataHelper;
import xaero.common.minimap.waypoints.Waypoint;
import xaero.common.minimap.waypoints.WaypointSet;
import xaero.common.minimap.waypoints.WaypointWorld;
import xaero.common.minimap.waypoints.WaypointWorldContainer;
import xaero.common.minimap.waypoints.WaypointWorldRootContainer;
import xaero.common.misc.OptimizedMath;
import xaero.common.settings.ModSettings;

public class WaypointsManager {
    private AXaeroMinimap modMain;
    private XaeroMinimapSession minimapSession;
    private class_310 mc;
    private HashMap<String, WaypointWorldContainer> waypointMap = new HashMap();
    private WaypointSet waypoints = null;
    private List<Waypoint> serverWaypoints = null;
    public static final Hashtable<String, Hashtable<Integer, Waypoint>> customWaypoints = new Hashtable();
    private String mainContainerID;
    private String containerID = null;
    private String containerIDIgnoreCaseCache;
    private String customContainerID = null;
    private String worldID = null;
    private String customWorldID = null;
    private class_2338 currentSpawn;
    public long setChanged;
    public static final String TELEPORT_ANYWAY_COMMAND = "xaero_tp_anyway";
    private Waypoint teleportAnywayWP;
    private WaypointWorld teleportAnywayWorld;

    public WaypointsManager(AXaeroMinimap modMain, XaeroMinimapSession minimapSession) {
        this.modMain = modMain;
        this.minimapSession = minimapSession;
        this.mc = class_310.method_1551();
    }

    public void onLoad(class_634 connection) {
        this.mainContainerID = this.getMainContainer(connection);
    }

    public double getDimensionDivision(String worldContainerID) {
        if (worldContainerID == null || class_310.method_1551().field_1687 == null) {
            return 1.0;
        }
        String dimPart = worldContainerID.substring(worldContainerID.lastIndexOf(47) + 1);
        class_5321<class_1937> dimKey = this.getDimensionKeyForDirectoryName(dimPart);
        if (dimKey == class_1937.field_25180 || dimKey == class_1937.field_25179 || dimKey == class_1937.field_25181) {
            double currentDimDiv = class_310.method_1551().field_1687.method_8597().comp_646();
            double selectedDimDiv = dimKey == class_1937.field_25180 ? 8.0 : 1.0;
            return currentDimDiv / selectedDimDiv;
        }
        return 1.0;
    }

    public String getDimensionDirectoryName(class_5321<class_1937> dimKey) {
        if (dimKey == class_1937.field_25179) {
            return "dim%0";
        }
        if (dimKey == class_1937.field_25180) {
            return "dim%-1";
        }
        if (dimKey == class_1937.field_25181) {
            return "dim%1";
        }
        class_2960 identifier = dimKey.method_29177();
        return "dim%" + identifier.method_12836() + "$" + identifier.method_12832().replace('/', '%');
    }

    public class_5321<class_1937> findDimensionKey(String validatedName) {
        Set allDimensions = this.mc.field_1724.field_3944.method_29356();
        for (class_5321 dk : allDimensions) {
            if (!validatedName.equals(dk.method_29177().method_12832().replaceAll("[^a-zA-Z0-9_]+", ""))) continue;
            return dk;
        }
        return null;
    }

    public class_5321<class_1937> getDimensionKeyForDirectoryName(String dirName) {
        String dimIdPart = dirName.substring(4);
        if (dimIdPart.equals("0")) {
            return class_1937.field_25179;
        }
        if (dimIdPart.equals("1")) {
            return class_1937.field_25181;
        }
        if (dimIdPart.equals("-1")) {
            return class_1937.field_25180;
        }
        String[] idArgs = dimIdPart.split("\\$");
        if (idArgs.length == 1) {
            return null;
        }
        try {
            Integer.parseInt(idArgs[1]);
            return null;
        }
        catch (NumberFormatException nfe) {
            return class_5321.method_29179((class_5321)class_7924.field_41223, (class_2960)new class_2960(idArgs[0], idArgs[1].replace('%', '/')));
        }
    }

    private String getMainContainer(class_634 connection) {
        Object potentialContainerID;
        if (this.mc.method_1576() != null) {
            potentialContainerID = this.mc.method_1576().method_27050(class_5218.field_24188).getParent().getFileName().toString().replace("_", "%us%").replace("/", "%fs%").replace("\\", "%bs%");
        } else if (this.mc.method_1589() && this.modMain.getEvents().latestRealm != null) {
            potentialContainerID = "Realms_" + this.modMain.getEvents().latestRealm.field_22605 + "." + this.modMain.getEvents().latestRealm.field_22599;
        } else if (connection.method_45734() != null) {
            String serverIP;
            String string = serverIP = this.modMain.getSettings().differentiateByServerAddress ? connection.method_45734().field_3761 : "Any Address";
            if (serverIP.contains(":")) {
                serverIP = serverIP.substring(0, serverIP.indexOf(":"));
            }
            while (serverIP.endsWith(".")) {
                serverIP = serverIP.substring(0, serverIP.length() - 1);
            }
            potentialContainerID = "Multiplayer_" + serverIP.replace(":", "\u00a7").replace("_", "%us%").replace("/", "%fs%").replace("\\", "%bs%");
        } else {
            potentialContainerID = "Unknown";
        }
        potentialContainerID = this.ignoreContainerCase((String)potentialContainerID, null);
        return potentialContainerID;
    }

    public String ignoreContainerCase(String potentialContainerID, String current) {
        if (potentialContainerID.equalsIgnoreCase(current)) {
            return current;
        }
        Set<Map.Entry<String, WaypointWorldContainer>> entries = this.waypointMap.entrySet();
        for (Map.Entry<String, WaypointWorldContainer> e : entries) {
            String containerSearch = e.getValue().getEqualIgnoreCaseSub(potentialContainerID);
            if (containerSearch == null) continue;
            return containerSearch;
        }
        return potentialContainerID;
    }

    public String getNewAutoWorldID(class_5321<class_1937> dimId, boolean useWorldmap) {
        String worldmapMultiworldId;
        if (this.mc.method_1576() != null) {
            return "waypoints";
        }
        WaypointWorldRootContainer rootContainer = (WaypointWorldRootContainer)this.getWorldContainer(this.mainContainerID);
        Object autoIdBase = this.getAutoIdBase(rootContainer);
        String string = worldmapMultiworldId = useWorldmap ? this.modMain.getSupportMods().worldmapSupport.tryToGetMultiworldId(dimId) : null;
        if (!(autoIdBase == null || useWorldmap && worldmapMultiworldId == null)) {
            Object actualMultiworldId;
            if (autoIdBase instanceof class_2338) {
                class_2338 pos = (class_2338)autoIdBase;
                actualMultiworldId = "mw" + (pos.method_10263() >> 6) + "," + (pos.method_10264() >> 6) + "," + (pos.method_10260() >> 6);
                if (!rootContainer.isUsingMultiworldDetection()) {
                    String defaultMultiworldId = rootContainer.getDefaultMultiworldId();
                    if (defaultMultiworldId == null) {
                        rootContainer.setDefaultMultiworldId((String)actualMultiworldId);
                        rootContainer.saveConfig();
                    } else {
                        actualMultiworldId = defaultMultiworldId;
                    }
                }
            } else {
                actualMultiworldId = "mw$" + autoIdBase;
            }
            if (useWorldmap && !worldmapMultiworldId.equals("minimap")) {
                actualMultiworldId = worldmapMultiworldId;
            }
            return actualMultiworldId;
        }
        return null;
    }

    public String getCurrentContainerAndWorldID() {
        return this.getCurrentContainerAndWorldID(this.containerID, this.worldID);
    }

    public String getCurrentContainerID() {
        return this.getCurrentContainerID(this.containerID);
    }

    public String getCurrentWorldID() {
        return this.getCurrentWorldID(this.worldID);
    }

    public WaypointWorld getCurrentWorld() {
        return this.getCurrentWorld(this.containerID, this.worldID);
    }

    public String getCurrentOriginContainerID() {
        return this.getCurrentOriginContainerID(this.containerID);
    }

    public String getCurrentContainerAndWorldID(String autoContainer, String autoWorldID) {
        return this.getCurrentContainerID(autoContainer) + "_" + this.getCurrentWorldID(autoWorldID);
    }

    public String getCurrentContainerID(String autoContainer) {
        if (this.customContainerID == null) {
            return autoContainer;
        }
        return this.customContainerID;
    }

    public String getCurrentWorldID(String autoWorldID) {
        if (this.customWorldID == null) {
            return autoWorldID;
        }
        return this.customWorldID;
    }

    public WaypointWorld getCurrentWorld(String autoContainer, String autoWorldID) {
        return this.getWorld(this.getCurrentContainerID(autoContainer), this.getCurrentWorldID(autoWorldID));
    }

    public String getCurrentOriginContainerID(String autoContainer) {
        if (this.getCurrentContainerID(autoContainer) == null) {
            return null;
        }
        return this.getCurrentContainerID(autoContainer).split("/")[0];
    }

    public WaypointWorld getAutoWorld() {
        return this.getWorld(this.getAutoContainerID(), this.getAutoWorldID());
    }

    public String getAutoRootContainerID() {
        return this.mainContainerID;
    }

    public String getAutoContainerID() {
        return this.containerID;
    }

    public String getAutoWorldID() {
        return this.worldID;
    }

    public WaypointWorld getWorld(String container, String world) {
        return this.addWorld(container, world);
    }

    public WaypointWorld addWorld(String container, String world) {
        if (container == null) {
            return null;
        }
        WaypointWorldContainer wc = this.addWorldContainer(container);
        return wc.addWorld(world);
    }

    public WaypointWorldContainer getWorldContainer(String id) {
        return this.addWorldContainer(id);
    }

    public WaypointWorldContainer addWorldContainer(String id) {
        WaypointWorldContainer container = null;
        String[] subs = id.split("/");
        for (int i = 0; i < subs.length; ++i) {
            if (i == 0) {
                container = this.waypointMap.get(subs[i]);
                if (container != null) continue;
                container = new WaypointWorldRootContainer(this.modMain, this.minimapSession, subs[i]);
                this.waypointMap.put(subs[i], container);
                WaypointWorldRootContainer rootContainer = (WaypointWorldRootContainer)container;
                if (rootContainer.configLoaded) continue;
                rootContainer.loadConfig();
                continue;
            }
            container = container.addSubContainer(subs[i]);
        }
        return container;
    }

    public WaypointWorldContainer getWorldContainerNullable(String id) {
        WaypointWorldContainer container = null;
        String[] subs = id.split("/");
        for (int i = 0; i < subs.length; ++i) {
            container = i == 0 ? this.waypointMap.get(subs[i]) : container.subContainers.get(subs[i]);
            if (container != null) continue;
            return null;
        }
        return container;
    }

    public void removeContainer(String id) {
        WaypointWorldContainer container = null;
        String[] subs = id.split("/");
        for (int i = 0; i < subs.length; ++i) {
            if (i == 0) {
                container = this.waypointMap.get(subs[i]);
                if (container == null) {
                    return;
                }
                if (i != subs.length - 1) continue;
                this.waypointMap.remove(subs[i]);
                return;
            }
            if (container.containsSub(subs[i])) {
                if (i == subs.length - 1) {
                    container.deleteSubContainer(subs[i]);
                    return;
                }
                container = container.addSubContainer(subs[i]);
                continue;
            }
            return;
        }
    }

    public boolean containerExists(String id) {
        WaypointWorldContainer container = null;
        String[] subs = id.split("/");
        for (int i = 0; i < subs.length; ++i) {
            if (i == 0) {
                container = this.waypointMap.get(subs[i]);
                if (container == null) {
                    return false;
                }
                if (i != subs.length - 1) continue;
                return true;
            }
            if (container.containsSub(subs[i])) {
                if (i == subs.length - 1) {
                    return true;
                }
                container = container.addSubContainer(subs[i]);
                continue;
            }
            return false;
        }
        return false;
    }

    public void updateWorldIds() {
        String oldContainerID = this.containerID;
        String oldWorldID = this.worldID;
        this.containerIDIgnoreCaseCache = this.containerID = this.getPotentialContainerID();
        String potentialWorldID = this.getNewAutoWorldID((class_5321<class_1937>)this.mc.field_1687.method_27983(), this.modMain.getSupportMods().worldmap());
        if (potentialWorldID == null) {
            this.containerID = oldContainerID;
            this.worldID = oldWorldID;
        } else {
            this.worldID = potentialWorldID;
            if (this.containerID != null && !this.containerID.equals(oldContainerID)) {
                if (oldWorldID != null && oldWorldID.startsWith("plugin")) {
                    WaypointWorldContainer oldContainer = this.getWorldContainer(oldContainerID);
                    ArrayList<WaypointWorld> worlds = new ArrayList<WaypointWorld>(oldContainer.worlds.values());
                    for (int i = 0; i < worlds.size(); ++i) {
                        worlds.get(i).getServerWaypoints().clear();
                    }
                }
                WaypointWorldContainer rootContainer = this.getWorldContainer(this.mainContainerID);
                rootContainer.renameOldContainer(this.containerID);
            }
        }
    }

    private String getPotentialContainerID() {
        return this.ignoreContainerCase(this.mainContainerID + "/" + this.getDimensionDirectoryName((class_5321<class_1937>)this.mc.field_1687.method_27983()), this.containerIDIgnoreCaseCache);
    }

    public void updateWaypoints() {
        if (this.containerID != null && this.worldID != null) {
            this.addWorld(this.containerID, this.worldID);
            WaypointWorld world = this.getCurrentWorld();
            this.waypoints = world.getCurrentSet();
            this.serverWaypoints = !world.getServerWaypoints().isEmpty() ? new ArrayList<Waypoint>(world.getServerWaypoints().values()) : null;
        }
    }

    public void createDeathpoint(class_1657 p) {
        WaypointWorld autoWorld;
        boolean shouldAddToAuto;
        this.updateWorldIds();
        if (this.modMain.getSettings().switchToAutoOnDeath) {
            this.setCustomContainerID(null);
            this.setCustomWorldID(null);
        }
        boolean bl = shouldAddToAuto = (autoWorld = this.getAutoWorld()) != null;
        if (this.modMain.getSupportMods().worldmap()) {
            String realCurrentDimContainerKey = this.getPotentialContainerID();
            boolean containerIsSynced = realCurrentDimContainerKey.equals(this.containerID);
            List<String> allPotentialMWIds = this.modMain.getSupportMods().worldmapSupport.getPotentialMultiworldIds((class_5321<class_1937>)this.mc.field_1687.method_27983());
            if (allPotentialMWIds != null && !allPotentialMWIds.isEmpty()) {
                for (String mwId : allPotentialMWIds) {
                    WaypointWorld potentialWorld = this.getWorld(realCurrentDimContainerKey, mwId);
                    if (containerIsSynced && potentialWorld == autoWorld) continue;
                    this.createDeathpoint(p, potentialWorld, false);
                }
                boolean bl2 = shouldAddToAuto = shouldAddToAuto && containerIsSynced;
            }
        }
        if (shouldAddToAuto) {
            this.createDeathpoint(p, autoWorld, false);
        }
    }

    private void createDeathpoint(class_1657 p, WaypointWorld wpw, boolean temp) {
        boolean disabled = false;
        WaypointSet waypoints = wpw.getCurrentSet();
        if (waypoints == null) {
            return;
        }
        block2: for (WaypointSet set : wpw.getSets().values()) {
            for (int i = 0; i < set.getList().size(); ++i) {
                Waypoint w = set.getList().get(i);
                if (w.getWaypointType() != 1) continue;
                if (set == waypoints) {
                    disabled = w.isDisabled();
                }
                if (!this.modMain.getSettings().getOldDeathpoints()) {
                    set.getList().remove(i);
                    --i;
                    continue block2;
                }
                w.setType(2);
                w.setName("gui.xaero_deathpoint_old");
                continue block2;
            }
        }
        ArrayList<Waypoint> list = waypoints.getList();
        double dimDiv = this.getDimensionDivision(wpw.getContainer().getKey());
        if (this.modMain.getSettings().getDeathpoints()) {
            Waypoint deathpoint = new Waypoint(OptimizedMath.myFloor((double)OptimizedMath.myFloor(p.method_23317()) * dimDiv), OptimizedMath.myFloor(p.method_23318()), OptimizedMath.myFloor((double)OptimizedMath.myFloor(p.method_23321()) * dimDiv), "gui.xaero_deathpoint", "D", 0, 1);
            deathpoint.setDisabled(disabled);
            deathpoint.setTemporary(temp);
            list.add(0, deathpoint);
        }
        try {
            this.modMain.getSettings().saveWaypoints(wpw);
        }
        catch (IOException e) {
            MinimapLogs.LOGGER.error("suppressed exception", (Throwable)e);
        }
    }

    public void createTemporaryWaypoints(WaypointWorld waypointWorld, int x, int y, int z) {
        this.createTemporaryWaypoints(waypointWorld, x, y, z, true);
    }

    public void createTemporaryWaypoints(WaypointWorld waypointWorld, int x, int y, int z, boolean yIncluded) {
        if (this.modMain.getSettings().waypointsGUI(this) && waypointWorld != null) {
            double dimDiv = this.getDimensionDivision(this.getCurrentContainerID());
            x = OptimizedMath.myFloor((double)x * dimDiv);
            z = OptimizedMath.myFloor((double)z * dimDiv);
            Waypoint instant = new Waypoint(x, y, z, "Waypoint", "X", (int)(Math.random() * (double)ModSettings.ENCHANT_COLORS.length), 0, true, yIncluded);
            if (!this.modMain.getSettings().waypointsBottom) {
                waypointWorld.getCurrentSet().getList().add(0, instant);
            } else {
                waypointWorld.getCurrentSet().getList().add(instant);
            }
        }
    }

    public boolean canTeleport(boolean displayingTeleportableWorld, WaypointWorld displayedWorld) {
        return (this.modMain.getSettings().allowWrongWorldTeleportation || displayingTeleportableWorld) && displayedWorld.getContainer().getRootContainer().isTeleportationEnabled();
    }

    public void teleportAnyway() {
        if (this.teleportAnywayWP != null) {
            class_437 dummyScreen = new class_437((class_2561)class_2561.method_43470((String)"")){};
            class_310 minecraft = class_310.method_1551();
            dummyScreen.method_25423(minecraft, minecraft.method_22683().method_4486(), minecraft.method_22683().method_4502());
            this.teleportToWaypoint(this.teleportAnywayWP, this.teleportAnywayWorld, dummyScreen, false);
        }
    }

    public void teleportToWaypoint(Waypoint selected, WaypointWorld displayedWorld, class_437 screen) {
        this.teleportToWaypoint(selected, displayedWorld, screen, true);
    }

    public void teleportToWaypoint(Waypoint selected, WaypointWorld displayedWorld, class_437 screen, boolean respectHiddenCoords) {
        this.updateWorldIds();
        boolean displayingTeleportableWorld = this.isWorldTeleportable(displayedWorld);
        if (selected != null && this.canTeleport(displayingTeleportableWorld, displayedWorld)) {
            this.mc.method_1507(null);
            if (!selected.isYIncluded() && this.mc.field_1761.method_2908()) {
                class_5250 messageComponent = class_2561.method_43470((String)class_1074.method_4662((String)"gui.xaero_teleport_y_unknown", (Object[])new Object[0]));
                messageComponent.method_10862(messageComponent.method_10866().method_10977(class_124.field_1061));
                this.mc.field_1705.method_1743().method_1812((class_2561)messageComponent);
                return;
            }
            Object tpCommand = "";
            boolean reachableDimension = true;
            boolean crossDimension = false;
            WaypointWorldRootContainer rootContainer = displayedWorld.getContainer().getRootContainer();
            if (displayingTeleportableWorld && displayedWorld != this.getAutoWorld()) {
                if (!this.isTeleportationSafe(displayedWorld)) {
                    class_5250 messageComponent = class_2561.method_43470((String)class_1074.method_4662((String)"gui.xaero_teleport_not_connected", (Object[])new Object[0]));
                    messageComponent.method_10862(messageComponent.method_10866().method_10977(class_124.field_1061));
                    this.mc.field_1705.method_1743().method_1812((class_2561)messageComponent);
                    return;
                }
                crossDimension = true;
                String[] containerKeySplit = displayedWorld.getContainer().getKey().split("/");
                if (containerKeySplit.length > 1) {
                    String dimensionKey = containerKeySplit[1];
                    if (!dimensionKey.startsWith("dim%")) {
                        this.mc.field_1705.method_1743().method_1812((class_2561)class_2561.method_43471((String)"gui.xaero_visit_needed"));
                        return;
                    }
                    class_5321<class_1937> dimensionId = this.getDimensionKeyForDirectoryName(dimensionKey);
                    if (dimensionId != null) {
                        this.setCustomContainerID(null);
                        this.setCustomWorldID(null);
                        this.updateWaypoints();
                        tpCommand = "/execute in " + dimensionId.method_29177().toString() + " run ";
                    } else {
                        reachableDimension = false;
                    }
                } else {
                    reachableDimension = false;
                }
            }
            if (reachableDimension) {
                if (respectHiddenCoords && this.modMain.getSettings().hideWaypointCoordinates && this.mc.field_1690.method_42539().method_41753() != class_1659.field_7536) {
                    class_5250 messageComponent = class_2561.method_43470((String)class_1074.method_4662((String)"gui.xaero_teleport_coordinates_hidden", (Object[])new Object[0]));
                    messageComponent.method_10862(messageComponent.method_10866().method_10977(class_124.field_1075));
                    this.mc.field_1705.method_1743().method_1812((class_2561)messageComponent);
                    class_5250 clickableQuestion = class_2561.method_43470((String)("\u00a7e[" + class_1074.method_4662((String)"gui.xaero_teleport_anyway", (Object[])new Object[0]) + "]"));
                    clickableQuestion.method_10862(clickableQuestion.method_10866().method_10958(new class_2558(class_2558.class_2559.field_11750, "/xaero_tp_anyway")).method_10949(new class_2568(class_2568.class_5247.field_24342, (Object)class_2561.method_43470((String)class_1074.method_4662((String)"gui.xaero_teleport_shows_coordinates", (Object[])new Object[0])).method_27692(class_124.field_1061))));
                    this.teleportAnywayWP = selected;
                    this.teleportAnywayWorld = displayedWorld;
                    this.mc.field_1705.method_1743().method_1812((class_2561)clickableQuestion);
                } else {
                    String tpCommandPrefix;
                    int x = selected.getX();
                    int z = selected.getZ();
                    double dimDiv = this.getDimensionDivision(displayedWorld.getContainer().getKey());
                    if (!crossDimension && dimDiv != 1.0) {
                        x = (int)Math.floor((double)x / dimDiv);
                        z = (int)Math.floor((double)z / dimDiv);
                    }
                    String serverTpCommand = selected.isRotation() ? rootContainer.getServerTeleportCommandRotationFormat() : rootContainer.getServerTeleportCommandFormat();
                    String defaultTpCommand = selected.isRotation() ? this.modMain.getSettings().defaultWaypointTPCommandRotationFormat : this.modMain.getSettings().defaultWaypointTPCommandFormat;
                    String string = tpCommandPrefix = rootContainer.isUsingDefaultTeleportCommand() || serverTpCommand == null ? defaultTpCommand : serverTpCommand;
                    if (((String)tpCommand).length() > 0) {
                        if (tpCommandPrefix.startsWith("/")) {
                            tpCommandPrefix = tpCommandPrefix.substring(1);
                        }
                        if (tpCommandPrefix.startsWith("minecraft:")) {
                            tpCommandPrefix = tpCommandPrefix.substring(10);
                        }
                    }
                    String yString = !selected.isYIncluded() ? "~" : (this.modMain.getSettings().getPartialYTeleportation() ? "" + ((double)selected.getY() + 0.5) : "" + selected.getY());
                    tpCommandPrefix = tpCommandPrefix.replace("{x}", "" + x).replace("{y}", yString).replace("{z}", "" + z).replace("{name}", selected.getLocalizedName());
                    if (selected.isRotation()) {
                        tpCommandPrefix = tpCommandPrefix.replace("{yaw}", "" + selected.getYaw());
                    }
                    if (((String)(tpCommand = (String)tpCommand + tpCommandPrefix)).startsWith("/")) {
                        if (!this.mc.field_1724.field_3944.method_45731((String)(tpCommand = ((String)tpCommand).substring(1)))) {
                            this.mc.field_1724.field_3944.method_45730((String)tpCommand);
                        }
                    } else {
                        this.mc.field_1724.field_3944.method_45729((String)tpCommand);
                    }
                }
            } else {
                this.mc.field_1705.method_1743().method_1812((class_2561)class_2561.method_43470((String)class_1074.method_4662((String)"gui.xaero_unreachable_dimension", (Object[])new Object[0])).method_27692(class_124.field_1061));
            }
        }
    }

    public boolean isWorldTeleportable(WaypointWorld displayedWorld) {
        WaypointWorld autoWorld = this.getAutoWorld();
        WaypointWorldRootContainer rootContainer = displayedWorld.getContainer().getRootContainer();
        return rootContainer.getKey().equals(this.getAutoRootContainerID()) && (autoWorld == displayedWorld || this.modMain.getSettings().crossDimensionalTp && autoWorld != null && autoWorld.getContainer() != displayedWorld.getContainer());
    }

    public boolean isTeleportationSafe(WaypointWorld displayedWorld) {
        WaypointWorld autoWorld = this.getAutoWorld();
        WaypointWorldRootContainer rootContainer = displayedWorld.getContainer().getRootContainer();
        return rootContainer.getSubWorldConnections().isConnected(autoWorld, displayedWorld);
    }

    public WaypointSet getWaypoints() {
        return this.waypoints;
    }

    public void setWaypoints(WaypointSet waypoints) {
        this.waypoints = waypoints;
    }

    public List<Waypoint> getServerWaypoints() {
        return this.serverWaypoints;
    }

    public HashMap<String, WaypointWorldContainer> getWaypointMap() {
        return this.waypointMap;
    }

    public void setCurrentSpawn(class_2338 currentSpawn, class_638 clientWorld) {
        this.currentSpawn = currentSpawn;
    }

    public String getCustomContainerID() {
        return this.customContainerID;
    }

    public void setCustomContainerID(String customContainerID) {
        this.customContainerID = customContainerID;
    }

    public String getCustomWorldID() {
        return this.customWorldID;
    }

    public void setCustomWorldID(String customWorldID) {
        this.customWorldID = customWorldID;
    }

    public static Hashtable<Integer, Waypoint> getCustomWaypoints(String modName) {
        Hashtable<Integer, Waypoint> wps = customWaypoints.get(modName);
        if (wps == null) {
            wps = new Hashtable();
            customWaypoints.put(modName, wps);
        }
        return wps;
    }

    public boolean isMultiplayer(String containerId) {
        return containerId.startsWith("Multiplayer_") || containerId.startsWith("Realms_");
    }

    private boolean hasServerLevelId(WaypointWorldRootContainer rootContainer) {
        MinimapClientWorldData worldData = MinimapClientWorldDataHelper.getCurrentWorldData();
        return worldData.serverLevelId != null && !rootContainer.isIgnoreServerLevelId();
    }

    private Object getAutoIdBase(WaypointWorldRootContainer rootContainer) {
        MinimapClientWorldData worldData = MinimapClientWorldDataHelper.getCurrentWorldData();
        return this.hasServerLevelId(rootContainer) ? worldData.serverLevelId : this.currentSpawn;
    }

    public void onServerLevelId(int id) {
        MinimapClientWorldData worldData = MinimapClientWorldDataHelper.getCurrentWorldData();
        worldData.serverLevelId = id;
        MinimapLogs.LOGGER.info("Minimap updated server level id: " + id + " for world " + class_310.method_1551().field_1687.method_27983());
    }
}

