/*
 * Decompiled with CFR 0.152.
 */
package tk.meowmc.portalgun.misc;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiPredicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2499;
import net.minecraft.class_2519;
import net.minecraft.class_2960;
import net.minecraft.class_5321;
import net.minecraft.class_6862;
import net.minecraft.class_6880;
import net.minecraft.class_6885;
import net.minecraft.class_7923;
import net.minecraft.class_7924;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import qouteall.q_misc_util.Helper;
import qouteall.q_misc_util.my_util.LimitedLogger;

public record BlockList(List<String> list) {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final LimitedLogger LIMITED_LOGGER = new LimitedLogger(100);

    public static BlockList fromTag(class_2499 tag) {
        return new BlockList(Helper.listTagDeserialize((class_2499)tag, class_2519::method_10714, class_2519.class));
    }

    public BiPredicate<class_1937, class_2338> getWallPredicate() {
        if (this.list().isEmpty()) {
            return (w, p) -> w.method_8320(p).method_26216((class_1922)w, p);
        }
        Set allowedBlocks = this.asStream().collect(Collectors.toSet());
        return (w, p) -> allowedBlocks.contains(w.method_8320(p).method_26204());
    }

    public class_2499 toTag() {
        return Helper.listTagSerialize(this.list, class_2519::method_23256);
    }

    public Stream<class_2248> asStream() {
        return this.list.stream().flatMap(s -> BlockList.parseBlockStr(s).stream());
    }

    public static Collection<class_2248> parseBlockStr(String str) {
        if (str.startsWith("#")) {
            class_6862 tagKey = class_6862.method_40092((class_5321)class_7924.field_41254, (class_2960)new class_2960(str.substring(1)));
            Optional named = class_7923.field_41175.method_40266(tagKey);
            if (named.isEmpty()) {
                LIMITED_LOGGER.invoke(() -> LOGGER.error("Unknown block tag: {}", (Object)str));
                return Collections.emptyList();
            }
            class_6885.class_6888 holderSet = (class_6885.class_6888)named.get();
            return holderSet.method_40239().map(class_6880::comp_349).toList();
        }
        Optional optional = class_7923.field_41175.method_17966(new class_2960(str));
        if (optional.isPresent()) {
            return Collections.singletonList((class_2248)optional.get());
        }
        LIMITED_LOGGER.invoke(() -> LOGGER.error("Unknown block: {}", (Object)str));
        return Collections.emptyList();
    }
}

