/*
 * Decompiled with CFR 0.152.
 */
package tk.meowmc.portalgun.entities;

import java.util.function.BiPredicate;
import net.fabricmc.fabric.api.object.builder.v1.entity.FabricEntityTypeBuilder;
import net.minecraft.class_1299;
import net.minecraft.class_1311;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_3419;
import net.minecraft.class_4048;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import qouteall.imm_ptl.core.portal.Portal;
import qouteall.q_misc_util.my_util.IntBox;
import tk.meowmc.portalgun.PortalGunMod;
import tk.meowmc.portalgun.PortalGunRecord;
import tk.meowmc.portalgun.misc.BlockList;

public class CustomPortal
extends Portal {
    private static final Logger LOGGER = LogManager.getLogger();
    public static class_1299<CustomPortal> entityType = FabricEntityTypeBuilder.create((class_1311)class_1311.field_17715, CustomPortal::new).dimensions(class_4048.method_18384((float)0.0f, (float)0.0f)).build();
    public PortalGunRecord.PortalDescriptor descriptor;
    public IntBox wallBox;
    public IntBox airBox;
    private BlockList allowedBlocks;
    public int thisSideUpdateCounter = 0;
    public int otherSideUpdateCounter = 0;
    private BiPredicate<class_1937, class_2338> wallPredicate;

    public CustomPortal(@NotNull class_1299<?> entityType, class_1937 world) {
        super(entityType, world);
    }

    protected void method_5749(class_2487 compoundTag) {
        super.method_5749(compoundTag);
        this.descriptor = PortalGunRecord.PortalDescriptor.fromTag(compoundTag.method_10562("descriptor"));
        this.wallBox = IntBox.fromTag((class_2487)compoundTag.method_10562("wallBox"));
        this.airBox = IntBox.fromTag((class_2487)compoundTag.method_10562("airBox"));
        this.setAllowedBlocks(BlockList.fromTag(compoundTag.method_10554("allowedBlocks", 8)));
        this.thisSideUpdateCounter = compoundTag.method_10550("thisSideUpdateCounter");
        this.otherSideUpdateCounter = compoundTag.method_10550("otherSideUpdateCounter");
    }

    protected void method_5652(class_2487 compoundTag) {
        super.method_5652(compoundTag);
        compoundTag.method_10566("descriptor", (class_2520)this.descriptor.toTag());
        compoundTag.method_10566("wallBox", (class_2520)this.wallBox.toTag());
        compoundTag.method_10566("airBox", (class_2520)this.airBox.toTag());
        compoundTag.method_10566("allowedBlocks", (class_2520)this.allowedBlocks.toTag());
        compoundTag.method_10569("thisSideUpdateCounter", this.thisSideUpdateCounter);
        compoundTag.method_10569("otherSideUpdateCounter", this.otherSideUpdateCounter);
    }

    public void method_5773() {
        super.method_5773();
        if (!this.method_37908().field_9236) {
            this.updateState();
        }
    }

    public void method_5814(double x, double y, double z) {
        super.method_5814(x, y, z);
        this.method_22862();
    }

    public void setAllowedBlocks(BlockList allowedBlocks) {
        this.allowedBlocks = allowedBlocks;
        this.wallPredicate = allowedBlocks.getWallPredicate();
    }

    void updateState() {
        if (this.descriptor == null || this.wallBox == null) {
            LOGGER.error("Portal info abnormal {}", (Object)this);
            this.method_5768();
            return;
        }
        PortalGunRecord record = PortalGunRecord.get();
        PortalGunRecord.PortalInfo thisSideInfo = record.data.get(this.descriptor);
        PortalGunRecord.PortalInfo otherSideInfo = record.data.get(this.descriptor.getTheOtherSide());
        if (thisSideInfo == null) {
            this.playClosingSound();
            this.method_5768();
            return;
        }
        if (this.thisSideUpdateCounter != thisSideInfo.updateCounter() || !thisSideInfo.portalId().equals(this.method_5667())) {
            this.method_5768();
            return;
        }
        if (!this.checkBlockStatus()) {
            this.method_5768();
            record.data.remove(this.descriptor);
            record.method_80();
            this.playClosingSound();
            return;
        }
        if (otherSideInfo == null) {
            if (this.otherSideUpdateCounter != -1) {
                this.otherSideUpdateCounter = -1;
                this.teleportable = false;
                this.setIsVisible(false);
                this.setDestination(this.getOriginPos().method_1031(0.0, 10.0, 0.0));
                this.reloadAndSyncToClient();
            }
            return;
        }
        if (otherSideInfo.updateCounter() != this.otherSideUpdateCounter) {
            if (!this.isVisible()) {
                this.method_37908().method_43128(null, this.method_23317(), this.method_23318(), this.method_23321(), PortalGunMod.PORTAL_OPEN_EVENT, class_3419.field_15248, 1.0f, 1.0f);
            }
            this.otherSideUpdateCounter = otherSideInfo.updateCounter();
            this.teleportable = true;
            this.setIsVisible(true);
            this.setDestination(otherSideInfo.portalPos());
            this.setDestinationDimension(otherSideInfo.portalDim());
            this.setOtherSideOrientation(otherSideInfo.portalOrientation());
            this.reloadAndSyncToClient();
            return;
        }
    }

    private boolean checkBlockStatus() {
        if (this.wallPredicate == null) {
            return true;
        }
        boolean wallIntact = this.wallBox.fastStream().allMatch(p -> this.wallPredicate.test(this.method_37908(), (class_2338)p));
        if (!wallIntact) {
            return false;
        }
        return PortalGunMod.isAreaClear(this.method_37908(), this.airBox);
    }

    private void playClosingSound() {
        this.method_37908().method_43128(null, this.method_23317(), this.method_23318(), this.method_23321(), PortalGunMod.PORTAL_CLOSE_EVENT, class_3419.field_15248, 1.0f, 1.0f);
    }
}

