/*
 * Decompiled with CFR 0.152.
 */
package net.diebuddies.physics.liquid;

import net.diebuddies.compat.Iris;
import net.diebuddies.compat.Optifine;
import net.diebuddies.opengl.Pack;
import net.diebuddies.physics.PhysicsWorld;
import net.diebuddies.physics.StarterClient;
import net.diebuddies.physics.liquid.Liquid;
import net.diebuddies.physics.liquid.LiquidController;
import net.diebuddies.physics.liquid.LiquidCuda;
import net.diebuddies.physics.liquid.SimpleTextureDimension;
import net.minecraft.class_1044;
import net.minecraft.class_1163;
import net.minecraft.class_1920;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import org.joml.Vector3d;

public class CudaWaterController
implements LiquidController {
    private double width;
    private double height;
    private double depth;
    private double radius = -1.0;
    private boolean sphere;
    private class_2338 pos;
    private class_238 aabb;

    public CudaWaterController(class_2338 pos, double width, double height, double depth) {
        this.width = width;
        this.height = height;
        this.depth = depth;
        this.pos = pos;
        this.aabb = new class_238(pos);
    }

    public CudaWaterController(class_2338 pos, double radius) {
        this.radius = radius;
        this.pos = pos;
        this.aabb = new class_238(pos);
    }

    @Override
    public void init(PhysicsWorld world, Liquid liquid) {
        SimpleTextureDimension dimension;
        liquid.blockPos = this.pos;
        liquid.sourceAlive = true;
        liquid.origin = new Vector3d((this.aabb.field_1323 + this.aabb.field_1320) * 0.5, (this.aabb.field_1322 + this.aabb.field_1325) * 0.5, (this.aabb.field_1321 + this.aabb.field_1324) * 0.5);
        if (StarterClient.iris) {
            liquid.materialID = Iris.getMaterialID(class_2246.field_10382.method_9564());
        } else if (StarterClient.optifabric) {
            liquid.materialID = (short)Optifine.getMaterialID(class_2246.field_10382.method_9564());
        }
        int color = class_1163.method_4961((class_1920)liquid.world.getWorld(), (class_2338)this.pos);
        liquid.color = Pack.color((float)(color >> 16 & 0xFF) / 255.0f, (float)(color >> 8 & 0xFF) / 255.0f, (float)(color & 0xFF) / 255.0f);
        class_1044 texture = class_310.method_1551().method_1531().method_4619(new class_2960("minecraft:textures/block/water_flow.png"));
        if (texture instanceof SimpleTextureDimension && (dimension = (SimpleTextureDimension)texture).getWidth() != dimension.getHeight()) {
            liquid.textureScale.y = (float)dimension.getWidth() / (float)dimension.getHeight();
        }
        liquid.textureScale.mul(0.66666f);
        liquid.textureID = texture.method_4624();
        if (liquid instanceof LiquidCuda) {
            LiquidCuda liquidCuda = (LiquidCuda)liquid;
            if (this.radius > 0.0) {
                liquidCuda.initSphereParticles(world, liquid.origin.x, liquid.origin.y, liquid.origin.z, this.radius);
            } else {
                liquidCuda.initBoxParticles(world, liquid.origin.x - this.width * 0.5, liquid.origin.y - this.height * 0.5, liquid.origin.z - this.depth * 0.5, this.width, this.height, this.depth);
            }
        }
    }

    @Override
    public void update(Liquid liquid, double diff) {
        if (StarterClient.iris) {
            liquid.materialID = Iris.getMaterialID(class_2246.field_10382.method_9564());
        } else if (StarterClient.optifabric) {
            liquid.materialID = (short)Optifine.getMaterialID(class_2246.field_10382.method_9564());
        }
    }
}

