/*
 * Decompiled with CFR 0.152.
 */
package net.diebuddies.minecraft;

import net.diebuddies.math.Math;
import net.diebuddies.opengl.Pack;
import net.diebuddies.physics.IRigidBody;
import net.diebuddies.physics.Model;
import net.diebuddies.physics.PhysicsEntity;
import net.diebuddies.physics.PhysicsMod;
import net.minecraft.class_1058;
import net.minecraft.class_1799;
import net.minecraft.class_1920;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2680;
import net.minecraft.class_310;
import org.joml.Matrix4dc;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import org.joml.Vector3f;
import org.joml.Vector4f;
import org.lwjgl.system.MemoryStack;
import physx.common.PxVec3;
import physx.physics.PxRigidActor;
import physx.physics.PxRigidDynamic;

public class ParticleSpawner {
    public static void spawnEatingPhysicsParticle(class_1799 itemStack, class_1937 level, double x, double y, double z, double vx, double vy, double vz) {
        class_1058 sprite = class_310.method_1551().method_1480().method_4019(itemStack, level, null, 0).method_4711();
        PhysicsMod mod = PhysicsMod.getInstance(level);
        PhysicsEntity entity = new PhysicsEntity(PhysicsEntity.Type.PARTICLE, null);
        entity.getTransformation().translation(x, y, z);
        entity.getOldTransformation().set((Matrix4dc)entity.getTransformation());
        Model model = entity.models.get(0);
        model.texture = sprite;
        model.textureID = class_310.method_1551().method_1531().method_4619(sprite.method_45852()).method_4624();
        entity.scale = Math.random() * 0.06f + 0.04f;
        entity.backfaceCulling = true;
        model.mesh = PhysicsMod.brokenBlock.get(0);
        entity.physicsGroup = (byte)16;
        entity.physicsMask = (byte)19;
        IRigidBody body = mod.physicsWorld.addBlockParticle(entity);
        mod.physicsWorld.queue(() -> {
            PxRigidActor patt1987$temp = body.getRigidBody();
            if (patt1987$temp instanceof PxRigidDynamic) {
                PxRigidDynamic rigidBody = (PxRigidDynamic)patt1987$temp;
                try (MemoryStack mem = MemoryStack.stackPush();){
                    PxVec3 velocity = PxVec3.createAt(mem, MemoryStack::nmalloc, (float)vx, (float)vy * 1.3f + 1.0f, (float)vz);
                    rigidBody.setLinearVelocity(velocity);
                    PxVec3 avelocity = PxVec3.createAt(mem, MemoryStack::nmalloc, Math.random() * 4.0f, Math.random() * 4.0f, Math.random() * 4.0f);
                    rigidBody.setAngularVelocity(avelocity);
                }
            }
        });
        float uo = Math.random() * 3.0f;
        float vo = Math.random() * 3.0f;
        Vector4f customUVs = new Vector4f(sprite.method_4580((double)(uo / 4.0f * 16.0f)), sprite.method_4580((double)(uo / 4.0f * 16.0f)), sprite.method_4570((double)(vo / 4.0f * 16.0f)), sprite.method_4570((double)(vo / 4.0f * 16.0f)));
        float xScale = customUVs.y - customUVs.x;
        float yScale = customUVs.w - customUVs.z;
        model.textureMatrix = new Matrix4f().translate(customUVs.x, customUVs.z, 0.0f).scale(xScale, yScale, 0.0f);
    }

    public static void spawnSprintingPhysicsParticle(class_2680 state, class_2338 pos, class_1937 level, double x, double y, double z) {
        class_1058 sprite = class_310.method_1551().method_1541().method_3351().method_3339(state);
        PhysicsMod mod = PhysicsMod.getInstance(level);
        PhysicsEntity entity = new PhysicsEntity(PhysicsEntity.Type.PARTICLE, null);
        entity.getTransformation().translation(x, y, z);
        entity.getOldTransformation().set((Matrix4dc)entity.getTransformation());
        Model model = entity.models.get(0);
        model.texture = sprite;
        model.textureID = class_310.method_1551().method_1531().method_4619(sprite.method_45852()).method_4624();
        entity.scale = Math.random() * 0.06f + 0.11f;
        entity.backfaceCulling = true;
        model.mesh = PhysicsMod.brokenBlock.get(0);
        entity.physicsGroup = (byte)16;
        entity.physicsMask = (byte)19;
        int color = class_310.method_1551().method_1505().method_1697(state, (class_1920)level, pos, 0);
        if (color == -1) {
            color = -1;
        }
        entity.setColor(color);
        if (state.method_26204() == class_2246.field_10593 || state.method_26204() == class_2246.field_10219) {
            entity.setColor(-1);
        }
        IRigidBody body = mod.physicsWorld.addBlockParticle(entity);
        mod.physicsWorld.queue(() -> {
            PxRigidActor patt4447$temp = body.getRigidBody();
            if (patt4447$temp instanceof PxRigidDynamic) {
                PxRigidDynamic rigidBody = (PxRigidDynamic)patt4447$temp;
                float strength = 3.0f;
                Vector3f speed = new Vector3f(0.0f, 0.3f, 0.0f);
                speed.x += (Math.random() - 0.5f) * 0.4f;
                speed.y += Math.random() * 0.4f;
                speed.z += (Math.random() - 0.5f) * 0.4f;
                speed.normalize();
                try (MemoryStack mem = MemoryStack.stackPush();){
                    PxVec3 velocity = PxVec3.createAt(mem, MemoryStack::nmalloc, speed.x * strength, speed.y * strength, speed.z * strength);
                    rigidBody.setLinearVelocity(velocity);
                    PxVec3 avelocity = PxVec3.createAt(mem, MemoryStack::nmalloc, Math.random() * 4.0f, Math.random() * 4.0f, Math.random() * 4.0f);
                    rigidBody.setAngularVelocity(avelocity);
                }
            }
        });
        float uo = Math.random() * 3.0f;
        float vo = Math.random() * 3.0f;
        Vector4f customUVs = new Vector4f(sprite.method_4580((double)(uo / 4.0f * 16.0f)), sprite.method_4580((double)((uo + 1.0f) / 4.0f * 16.0f)), sprite.method_4570((double)(vo / 4.0f * 16.0f)), sprite.method_4570((double)((vo + 1.0f) / 4.0f * 16.0f)));
        float xScale = customUVs.y - customUVs.x;
        float yScale = customUVs.w - customUVs.z;
        model.textureMatrix = new Matrix4f().translate(customUVs.x, customUVs.z, 0.0f).scale(xScale, yScale, 0.0f);
    }

    public static void spawnBloodPhysicsParticle(class_1937 level, double x, double y, double z) {
        PhysicsMod mod = PhysicsMod.getInstance(level);
        PhysicsEntity entity = new PhysicsEntity(PhysicsEntity.Type.PARTICLE, null);
        entity.getTransformation().translation(x, y, z);
        entity.getOldTransformation().set((Matrix4dc)entity.getTransformation());
        Model model = entity.models.get(0);
        model.textureID = PhysicsMod.whiteTexture.getID();
        entity.scale = Math.random() * 0.03f + 0.08f;
        entity.backfaceCulling = true;
        model.mesh = PhysicsMod.brokenBlock.get(0);
        float bloodModifier = Math.random() * 0.2f + 0.8f;
        entity.setColor(Pack.color(0.1f * bloodModifier, 0.1f * bloodModifier, 0.77f * bloodModifier));
        IRigidBody body = mod.physicsWorld.addBlockParticle(entity);
        mod.physicsWorld.queue(() -> {
            PxRigidActor patt6892$temp = body.getRigidBody();
            if (patt6892$temp instanceof PxRigidDynamic) {
                PxRigidDynamic rigidBody = (PxRigidDynamic)patt6892$temp;
                Vector3f speed = new Vector3f();
                speed.x = Math.random() - 0.5f;
                speed.y = Math.random() - 0.5f;
                speed.z = Math.random() - 0.5f;
                float strength = Math.random() * 2.0f + 1.0f;
                if (speed.lengthSquared() > 0.0f) {
                    speed.normalize();
                }
                try (MemoryStack mem = MemoryStack.stackPush();){
                    PxVec3 velocity = PxVec3.createAt(mem, MemoryStack::nmalloc, speed.x * strength, speed.y * strength, speed.z * strength);
                    rigidBody.setLinearVelocity(velocity);
                    PxVec3 avelocity = PxVec3.createAt(mem, MemoryStack::nmalloc, Math.random() * 4.0f, Math.random() * 4.0f, Math.random() * 4.0f);
                    rigidBody.setAngularVelocity(avelocity);
                }
            }
        });
    }

    public static void spawnOceanPhysicsParticle(class_1937 level, double x, double y, double z, double vx, double vz) {
        PhysicsMod mod = PhysicsMod.getInstance(level);
        PhysicsEntity entity = new PhysicsEntity(PhysicsEntity.Type.PARTICLE, null);
        entity.getTransformation().translation(x, y, z);
        entity.getOldTransformation().set((Matrix4dc)entity.getTransformation());
        Model model = entity.models.get(0);
        model.textureID = PhysicsMod.whiteTexture.getID();
        entity.scale = Math.random() * 0.05f + 0.11f;
        entity.backfaceCulling = true;
        model.mesh = PhysicsMod.brokenBlock.get(0);
        entity.physicsGroup = (byte)16;
        entity.physicsMask = (byte)19;
        entity.setColor(-1);
        IRigidBody body = mod.physicsWorld.addBlockParticle(entity);
        mod.physicsWorld.queue(() -> {
            PxRigidActor patt8713$temp = body.getRigidBody();
            if (patt8713$temp instanceof PxRigidDynamic) {
                PxRigidDynamic rigidBody = (PxRigidDynamic)patt8713$temp;
                Vector3f speed = new Vector3f((float)vx, 0.0f, (float)vz);
                speed.x *= Math.random();
                speed.y = 0.0f;
                speed.z += Math.random();
                float strength = Math.random() * 2.0f + 1.0f;
                if (speed.lengthSquared() > 0.0f) {
                    speed.normalize();
                }
                try (MemoryStack mem = MemoryStack.stackPush();){
                    PxVec3 velocity = PxVec3.createAt(mem, MemoryStack::nmalloc, speed.x * strength, speed.y * strength, speed.z * strength);
                    rigidBody.setLinearVelocity(velocity);
                    PxVec3 avelocity = PxVec3.createAt(mem, MemoryStack::nmalloc, Math.random() * 4.0f, Math.random() * 4.0f, Math.random() * 4.0f);
                    rigidBody.setAngularVelocity(avelocity);
                }
            }
        });
    }

    public static void spawnServerBlockPhysicsParticle(class_2680 state, class_1937 level, double x, double y, double z, double vx, double vy, double vz) {
        class_1058 sprite = class_310.method_1551().method_1541().method_3351().method_3339(state);
        PhysicsMod mod = PhysicsMod.getInstance(level);
        PhysicsEntity entity = new PhysicsEntity(PhysicsEntity.Type.PARTICLE, null);
        entity.getTransformation().translation(x, y, z);
        entity.getOldTransformation().set((Matrix4dc)entity.getTransformation());
        Model model = entity.models.get(0);
        model.texture = sprite;
        model.textureID = class_310.method_1551().method_1531().method_4619(sprite.method_45852()).method_4624();
        entity.scale = Math.random() * 0.06f + 0.11f;
        entity.backfaceCulling = true;
        model.mesh = PhysicsMod.brokenBlock.get(0);
        entity.physicsGroup = (byte)16;
        entity.physicsMask = (byte)19;
        int color = class_310.method_1551().method_1505().method_1697(state, (class_1920)level, class_2338.method_49637((double)x, (double)y, (double)z), 0);
        if (color == -1) {
            color = -1;
        }
        entity.setColor(color);
        if (state.method_26204() == class_2246.field_10593 || state.method_26204() == class_2246.field_10219) {
            entity.setColor(-1);
        }
        IRigidBody body = mod.physicsWorld.addBlockParticle(entity);
        mod.physicsWorld.queue(() -> {
            PxRigidActor patt11026$temp = body.getRigidBody();
            if (patt11026$temp instanceof PxRigidDynamic) {
                PxRigidDynamic rigidBody = (PxRigidDynamic)patt11026$temp;
                float strength = 2.0f;
                try (MemoryStack mem = MemoryStack.stackPush();){
                    PxVec3 velocity = PxVec3.createAt(mem, MemoryStack::nmalloc, (float)vx * strength, (float)vy * strength, (float)vz * strength);
                    rigidBody.setLinearVelocity(velocity);
                    PxVec3 avelocity = PxVec3.createAt(mem, MemoryStack::nmalloc, Math.random() * 4.0f, Math.random() * 4.0f, Math.random() * 4.0f);
                    rigidBody.setAngularVelocity(avelocity);
                }
            }
        });
        float uo = Math.random() * 3.0f;
        float vo = Math.random() * 3.0f;
        Vector4f customUVs = new Vector4f(sprite.method_4580((double)(uo / 4.0f * 16.0f)), sprite.method_4580((double)((uo + 1.0f) / 4.0f * 16.0f)), sprite.method_4570((double)(vo / 4.0f * 16.0f)), sprite.method_4570((double)((vo + 1.0f) / 4.0f * 16.0f)));
        float xScale = customUVs.y - customUVs.x;
        float yScale = customUVs.w - customUVs.z;
        model.textureMatrix = new Matrix4f().translate(customUVs.x, customUVs.z, 0.0f).scale(xScale, yScale, 0.0f);
    }

    public static void spawnItemPhysicsParticle(class_1058 sprite, class_1937 level, double x, double y, double z, float size, float depthScale, float uvx, float uvy, Matrix4f transformation) {
        PhysicsMod mod = PhysicsMod.getInstance(level);
        PhysicsEntity entity = new PhysicsEntity(PhysicsEntity.Type.PARTICLE, null);
        entity.getTransformation().set((Matrix4fc)transformation).translate(x, y, z).scale(1.0, 1.0, (double)depthScale);
        entity.getOldTransformation().set((Matrix4dc)entity.getTransformation());
        Model model = entity.models.get(0);
        model.texture = sprite;
        model.textureID = class_310.method_1551().method_1531().method_4619(sprite.method_45852()).method_4624();
        entity.scale = size;
        entity.backfaceCulling = true;
        model.mesh = PhysicsMod.brokenBlock.get(0);
        entity.physicsGroup = (byte)16;
        entity.physicsMask = (byte)19;
        IRigidBody body = mod.physicsWorld.addBlockParticle(entity);
        mod.physicsWorld.queue(() -> {
            PxRigidActor patt13229$temp = body.getRigidBody();
            if (patt13229$temp instanceof PxRigidDynamic) {
                PxRigidDynamic rigidBody = (PxRigidDynamic)patt13229$temp;
                float strength = 2.0f;
                try (MemoryStack mem = MemoryStack.stackPush();){
                    PxVec3 velocity = PxVec3.createAt(mem, MemoryStack::nmalloc, (Math.random() - 0.5f) * strength, (Math.random() - 0.5f) * strength * 1.6f, (Math.random() - 0.5f) * strength);
                    rigidBody.setLinearVelocity(velocity);
                    PxVec3 avelocity = PxVec3.createAt(mem, MemoryStack::nmalloc, Math.random() * 4.0f, Math.random() * 4.0f, Math.random() * 4.0f);
                    rigidBody.setAngularVelocity(avelocity);
                }
            }
        });
        Vector4f customUVs = new Vector4f(sprite.method_4580((double)(uvx * 16.0f)), sprite.method_4580((double)(uvx * 16.0f)), sprite.method_4570((double)(uvy * 16.0f)), sprite.method_4570((double)(uvy * 16.0f)));
        float xScale = customUVs.y - customUVs.x;
        float yScale = customUVs.w - customUVs.z;
        model.textureMatrix = new Matrix4f().translate(customUVs.x, customUVs.z, 0.0f).scale(xScale, yScale, 0.0f);
    }
}

