/*
 * Decompiled with CFR 0.152.
 */
package me.cortex.nvidium.util;

import it.unimi.dsi.fastutil.longs.LongArrayList;
import it.unimi.dsi.fastutil.longs.LongList;
import it.unimi.dsi.fastutil.longs.LongListIterator;
import it.unimi.dsi.fastutil.objects.ReferenceArrayList;
import java.util.List;
import me.cortex.nvidium.gl.RenderDevice;
import me.cortex.nvidium.gl.buffers.Buffer;
import me.cortex.nvidium.gl.buffers.PersistentClientMappedBuffer;
import me.cortex.nvidium.util.SegmentedManager;
import me.cortex.nvidium.util.TickableManager;
import org.lwjgl.opengl.GL11;

public class UploadingBufferStream {
    private final SegmentedManager segments = new SegmentedManager();
    private final RenderDevice device;
    private PersistentClientMappedBuffer buffer;
    private final List<Batch> batchedCopies = new ReferenceArrayList();
    private final LongList batchedFlushes = new LongArrayList();
    private int cidx;
    private final LongList[] allocations;
    private long caddr = -1L;
    private long offset = 0L;

    public UploadingBufferStream(RenderDevice device, int frames, long size) {
        this.device = device;
        this.allocations = new LongList[frames];
        for (int i = 0; i < frames; ++i) {
            this.allocations[i] = new LongArrayList();
        }
        this.segments.setLimit(size);
        this.buffer = device.createClientMappedBuffer(size);
        TickableManager.register(this);
    }

    public long getUpload(Buffer destBuffer, long destOffset, int size) {
        long addr;
        if (this.caddr == -1L || !this.segments.expand(this.caddr, size)) {
            this.caddr = this.segments.alloc(size);
            if (this.caddr == -1L) {
                this.commit();
                GL11.glFinish();
                for (int i = 0; i < this.allocations.length; ++i) {
                    this.tick();
                }
                this.caddr = this.segments.alloc(size);
                if (this.caddr == -1L) {
                    throw new IllegalStateException("Could not allocate memory segment big enough for upload");
                }
            }
            this.allocations[this.cidx].add(this.caddr);
            this.offset = size;
            addr = this.caddr;
            this.batchedFlushes.add(this.caddr);
        } else {
            addr = this.caddr + this.offset;
            this.offset += (long)size;
        }
        this.batchedCopies.add(new Batch(destBuffer, destOffset, addr, size));
        return this.buffer.clientAddress() + addr;
    }

    public void commit() {
        LongListIterator longListIterator = this.batchedFlushes.iterator();
        while (longListIterator.hasNext()) {
            long offset = (Long)longListIterator.next();
            this.device.flush(this.buffer, offset, (int)this.segments.getSize(offset));
        }
        this.batchedFlushes.clear();
        this.device.barrier(16384);
        for (Batch batch : this.batchedCopies) {
            this.device.copyBuffer(this.buffer, batch.dest, batch.sourceOffset, batch.destOffset, batch.size);
        }
        this.batchedCopies.clear();
        this.device.barrier(512);
    }

    public void delete() {
        this.buffer.delete();
    }

    void tick() {
        this.cidx = (this.cidx + 1) % this.allocations.length;
        LongListIterator longListIterator = this.allocations[this.cidx].iterator();
        while (longListIterator.hasNext()) {
            long addr = (Long)longListIterator.next();
            this.segments.free(addr);
        }
        this.allocations[this.cidx].clear();
        this.caddr = -1L;
    }

    private record Batch(Buffer dest, long destOffset, long sourceOffset, long size) {
    }
}

