/*
 * Decompiled with CFR 0.152.
 */
package me.cortex.nvidium.sodiumCompat;

import java.nio.ByteBuffer;
import me.cortex.nvidium.sodiumCompat.IrisCheck;
import me.cortex.nvidium.sodiumCompat.RepackagedSectionOutput;
import me.jellysquid.mods.sodium.client.gl.util.VertexRange;
import me.jellysquid.mods.sodium.client.render.chunk.compile.ChunkBuildOutput;
import me.jellysquid.mods.sodium.client.render.chunk.data.BuiltSectionMeshParts;
import me.jellysquid.mods.sodium.client.render.chunk.terrain.DefaultTerrainRenderPasses;
import me.jellysquid.mods.sodium.client.util.NativeBuffer;
import org.joml.Vector3i;
import org.lwjgl.system.MemoryUtil;

public class SodiumResultCompatibility {
    public static RepackagedSectionOutput repackage(ChunkBuildOutput result) {
        int formatSize = 16;
        int geometryBytes = result.meshes.values().stream().mapToInt(a -> a.getVertexData().getLength()).sum();
        NativeBuffer output = new NativeBuffer(geometryBytes);
        short[] offsets = new short[8];
        Vector3i min = new Vector3i(2000);
        Vector3i max = new Vector3i(-2000);
        SodiumResultCompatibility.packageSectionGeometry(formatSize, output, offsets, result, min, max);
        min.x = Math.max(min.x, 0);
        min.y = Math.max(min.y, 0);
        min.z = Math.max(min.z, 0);
        min.x = Math.min(min.x, 15);
        min.y = Math.min(min.y, 15);
        min.z = Math.min(min.z, 15);
        max.x = Math.min(max.x, 16);
        max.y = Math.min(max.y, 16);
        max.z = Math.min(max.z, 16);
        max.x = Math.max(max.x, 0);
        max.y = Math.max(max.y, 0);
        max.z = Math.max(max.z, 0);
        Vector3i size = new Vector3i(max.x - min.x - 1, max.y - min.y - 1, max.z - min.z - 1);
        size.x = Math.min(15, Math.max(size.x, 0));
        size.y = Math.min(15, Math.max(size.y, 0));
        size.z = Math.min(15, Math.max(size.z, 0));
        return new RepackagedSectionOutput(geometryBytes / formatSize / 4, output, offsets, min, size);
    }

    private static void packageSectionGeometry(int formatSize, NativeBuffer output, short[] outOffsets, ChunkBuildOutput result, Vector3i min, Vector3i max) {
        int offset = 0;
        long outPtr = MemoryUtil.memAddress((ByteBuffer)output.getDirectBuffer());
        BuiltSectionMeshParts translucentData = (BuiltSectionMeshParts)result.meshes.get(DefaultTerrainRenderPasses.TRANSLUCENT);
        if (translucentData != null) {
            for (int i = 0; i < 7; ++i) {
                VertexRange part = translucentData.getVertexRanges()[i];
                if (part == null) continue;
                long src = MemoryUtil.memAddress((ByteBuffer)translucentData.getVertexData().getDirectBuffer()) + (long)part.vertexStart() * (long)formatSize;
                long dst = outPtr + (long)offset * 4L * (long)formatSize;
                MemoryUtil.memCopy((long)src, (long)dst, (long)((long)part.vertexCount() * (long)formatSize));
                for (int j = 0; j < part.vertexCount(); ++j) {
                    long base = dst + (long)j * (long)formatSize;
                    short flags = 4;
                    MemoryUtil.memPutShort((long)(base + 6L), (short)flags);
                    SodiumResultCompatibility.updateSectionBounds(min, max, base);
                }
                offset += part.vertexCount() / 4;
            }
        }
        outOffsets[7] = (short)offset;
        BuiltSectionMeshParts solid = (BuiltSectionMeshParts)result.meshes.get(DefaultTerrainRenderPasses.SOLID);
        BuiltSectionMeshParts cutout = (BuiltSectionMeshParts)result.meshes.get(DefaultTerrainRenderPasses.CUTOUT);
        for (int i = 0; i < 7; ++i) {
            long base;
            int j;
            long dst;
            long src;
            VertexRange part;
            int poff = offset;
            if (solid != null && (part = solid.getVertexRanges()[i]) != null) {
                src = MemoryUtil.memAddress((ByteBuffer)solid.getVertexData().getDirectBuffer()) + (long)part.vertexStart() * (long)formatSize;
                dst = outPtr + (long)offset * 4L * (long)formatSize;
                MemoryUtil.memCopy((long)src, (long)dst, (long)((long)part.vertexCount() * (long)formatSize));
                for (j = 0; j < part.vertexCount(); ++j) {
                    base = dst + (long)j * (long)formatSize;
                    short flags = 4;
                    MemoryUtil.memPutShort((long)(base + 6L), (short)flags);
                    SodiumResultCompatibility.updateSectionBounds(min, max, base);
                }
                offset += part.vertexCount() / 4;
            }
            if (cutout != null && (part = cutout.getVertexRanges()[i]) != null) {
                src = MemoryUtil.memAddress((ByteBuffer)cutout.getVertexData().getDirectBuffer()) + (long)part.vertexStart() * (long)formatSize;
                dst = outPtr + (long)offset * 4L * (long)formatSize;
                MemoryUtil.memCopy((long)src, (long)dst, (long)((long)part.vertexCount() * (long)formatSize));
                for (j = 0; j < part.vertexCount(); ++j) {
                    base = dst + (long)j * (long)formatSize;
                    short sflags = MemoryUtil.memGetShort((long)(base + 6L));
                    short mipbits = (short)((sflags & 6) >> 1);
                    if (mipbits == 2 && IrisCheck.IRIS_LOADED) {
                        mipbits = 1;
                    }
                    short flags = (short)((sflags & 1) << 2 | mipbits);
                    MemoryUtil.memPutShort((long)(base + 6L), (short)flags);
                    SodiumResultCompatibility.updateSectionBounds(min, max, base);
                }
                offset += part.vertexCount() / 4;
            }
            outOffsets[i] = (short)(offset - poff);
        }
    }

    private static float decodePosition(short v) {
        return (float)Short.toUnsignedInt(v) * 4.8828125E-4f - 8.0f;
    }

    private static void updateSectionBounds(Vector3i min, Vector3i max, long vertex) {
        float x = SodiumResultCompatibility.decodePosition(MemoryUtil.memGetShort((long)vertex));
        float y = SodiumResultCompatibility.decodePosition(MemoryUtil.memGetShort((long)(vertex + 2L)));
        float z = SodiumResultCompatibility.decodePosition(MemoryUtil.memGetShort((long)(vertex + 4L)));
        min.x = (int)Math.min((double)min.x, Math.floor(x));
        min.y = (int)Math.min((double)min.y, Math.floor(y));
        min.z = (int)Math.min((double)min.z, Math.floor(z));
        max.x = (int)Math.max((double)max.x, Math.ceil(x));
        max.y = (int)Math.max((double)max.y, Math.ceil(y));
        max.z = (int)Math.max((double)max.z, Math.ceil(z));
    }
}

