/*
 * Decompiled with CFR 0.152.
 */
package me.cortex.nvidium;

import java.util.ArrayList;
import java.util.List;
import me.cortex.nvidium.Nvidium;
import me.cortex.nvidium.RenderPipeline;
import me.cortex.nvidium.gl.RenderDevice;
import me.cortex.nvidium.managers.AsyncOcclusionTracker;
import me.cortex.nvidium.managers.SectionManager;
import me.cortex.nvidium.util.DownloadTaskStream;
import me.cortex.nvidium.util.UploadingBufferStream;
import me.jellysquid.mods.sodium.client.SodiumClientMod;
import me.jellysquid.mods.sodium.client.render.chunk.ChunkRenderMatrices;
import me.jellysquid.mods.sodium.client.render.chunk.RenderSection;
import me.jellysquid.mods.sodium.client.render.chunk.compile.ChunkBuildOutput;
import me.jellysquid.mods.sodium.client.render.viewport.Viewport;
import net.minecraft.class_1058;
import net.minecraft.class_4184;
import org.jetbrains.annotations.Nullable;
import org.lwjgl.opengl.GL11;

public class NvidiumWorldRenderer {
    private static final RenderDevice device = new RenderDevice();
    private final UploadingBufferStream uploadStream;
    private final DownloadTaskStream downloadStream;
    private final SectionManager sectionManager;
    private final RenderPipeline renderPipeline;
    private final AsyncOcclusionTracker asyncChunkTracker;
    private long max_geometry_memory;
    private long last_sample_time;

    public NvidiumWorldRenderer(AsyncOcclusionTracker asyncChunkTracker) {
        int frames = SodiumClientMod.options().advanced.cpuRenderAheadLimit + 1;
        this.uploadStream = new UploadingBufferStream(device, frames, 32000000L);
        this.downloadStream = new DownloadTaskStream(device, frames, 8000000L);
        this.update_allowed_memory();
        this.sectionManager = new SectionManager(device, this.max_geometry_memory * 1024L * 1024L, this.uploadStream, 16);
        this.renderPipeline = new RenderPipeline(device, this.uploadStream, this.downloadStream, this.sectionManager);
        this.asyncChunkTracker = asyncChunkTracker;
    }

    public void delete() {
        this.uploadStream.delete();
        this.downloadStream.delete();
        this.renderPipeline.delete();
        this.asyncChunkTracker.delete();
        this.sectionManager.destroy();
    }

    public void reloadShaders() {
        this.renderPipeline.reloadShaders();
    }

    public void renderFrame(Viewport viewport, ChunkRenderMatrices matrices, double x, double y, double z) {
        this.renderPipeline.renderFrame(viewport, matrices, x, y, z);
        if ((long)this.sectionManager.terrainAreana.getUsedMB() > this.max_geometry_memory - 50L) {
            this.renderPipeline.removeARegion();
        }
        if (Nvidium.SUPPORTS_PERSISTENT_SPARSE_ADDRESSABLE_BUFFER && System.currentTimeMillis() - this.last_sample_time > 60000L) {
            this.last_sample_time = System.currentTimeMillis();
            this.update_allowed_memory();
        }
    }

    public void renderTranslucent() {
        this.renderPipeline.renderTranslucent();
    }

    public void deleteSection(RenderSection section) {
        this.sectionManager.deleteSection(section);
    }

    public void uploadBuildResult(ChunkBuildOutput buildOutput) {
        this.sectionManager.uploadChunkBuildResult(buildOutput);
    }

    public void addDebugInfo(ArrayList<String> debugInfo) {
        debugInfo.add("Using nvidium renderer: " + Nvidium.MOD_VERSION);
        debugInfo.add("Memory limit: " + this.max_geometry_memory + " mb");
        debugInfo.add("Terrain Memory MB: " + this.sectionManager.terrainAreana.getAllocatedMB() + (Nvidium.SUPPORTS_PERSISTENT_SPARSE_ADDRESSABLE_BUFFER ? "" : " (fallback mode)"));
        debugInfo.add(String.format("Fragmentation: %.2f", Float.valueOf(this.sectionManager.terrainAreana.getFragmentation() * 100.0f)));
        debugInfo.add("Regions: " + this.sectionManager.getRegionManager().regionCount() + "/" + this.sectionManager.getRegionManager().maxRegions());
        this.renderPipeline.addDebugInfo(debugInfo);
    }

    private void update_allowed_memory() {
        if (Nvidium.config.automatic_memory) {
            this.max_geometry_memory = (long)(GL11.glGetInteger((int)36937) / 1024) + (this.sectionManager == null ? 0L : this.sectionManager.terrainAreana.getMemoryUsed() / 0x100000L);
            this.max_geometry_memory -= 1024L;
            this.max_geometry_memory = Math.max(2048L, this.max_geometry_memory);
        } else {
            this.max_geometry_memory = Nvidium.config.max_geometry_memory;
        }
    }

    public void update(class_4184 camera, Viewport viewport, int frame, boolean spectator) {
        this.asyncChunkTracker.update(viewport);
    }

    public int getAsyncFrameId() {
        return this.asyncChunkTracker.getFrame();
    }

    public List<RenderSection> getSectionsWithEntities() {
        return this.asyncChunkTracker.getLatestSectionsWithEntities();
    }

    public SectionManager getSectionManager() {
        return this.sectionManager;
    }

    @Nullable
    public class_1058[] getAnimatedSpriteSet() {
        return this.asyncChunkTracker.getVisibleAnimatedSprites();
    }
}

