/*
 * Decompiled with CFR 0.152.
 */
package me.pepperbell.continuity.client.util;

import java.util.Collection;
import java.util.List;
import me.pepperbell.continuity.client.ContinuityClient;
import net.fabricmc.fabric.api.renderer.v1.RendererAccess;
import net.fabricmc.fabric.api.renderer.v1.material.BlendMode;
import net.fabricmc.fabric.api.renderer.v1.material.MaterialFinder;
import net.fabricmc.fabric.api.renderer.v1.material.RenderMaterial;
import net.fabricmc.fabric.api.renderer.v1.model.SpriteFinder;
import net.fabricmc.fabric.api.resource.IdentifiableResourceReloadListener;
import net.fabricmc.fabric.api.resource.ResourceManagerHelper;
import net.fabricmc.fabric.api.resource.ResourceReloadListenerKeys;
import net.fabricmc.fabric.api.resource.SimpleSynchronousResourceReloadListener;
import net.fabricmc.fabric.api.util.TriState;
import net.minecraft.class_1059;
import net.minecraft.class_1092;
import net.minecraft.class_1920;
import net.minecraft.class_2338;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_324;
import net.minecraft.class_3264;
import net.minecraft.class_3300;
import org.jetbrains.annotations.Nullable;

public final class RenderUtil {
    private static final class_324 BLOCK_COLORS = class_310.method_1551().method_1505();
    private static final class_1092 MODEL_MANAGER = class_310.method_1551().method_1554();
    private static final ThreadLocal<MaterialFinder> MATERIAL_FINDER = ThreadLocal.withInitial(() -> RendererAccess.INSTANCE.getRenderer().materialFinder());
    private static SpriteFinder blockAtlasSpriteFinder;

    public static int getTintColor(@Nullable class_2680 state, class_1920 blockView, class_2338 pos, int tintIndex) {
        if (state == null || tintIndex == -1) {
            return -1;
        }
        return 0xFF000000 | BLOCK_COLORS.method_1697(state, blockView, pos, tintIndex);
    }

    public static RenderMaterial findOverlayMaterial(BlendMode blendMode, @Nullable class_2680 tintBlock) {
        MaterialFinder finder = RenderUtil.getMaterialFinder();
        finder.blendMode(blendMode);
        if (tintBlock != null) {
            finder.ambientOcclusion(TriState.of((boolean)RenderUtil.canHaveAO(tintBlock)));
        } else {
            finder.ambientOcclusion(TriState.TRUE);
        }
        return finder.find();
    }

    public static boolean canHaveAO(class_2680 state) {
        return state.method_26213() == 0;
    }

    public static MaterialFinder getMaterialFinder() {
        return MATERIAL_FINDER.get().clear();
    }

    public static SpriteFinder getSpriteFinder() {
        return blockAtlasSpriteFinder;
    }

    public static class ReloadListener
    implements SimpleSynchronousResourceReloadListener {
        public static final class_2960 ID = ContinuityClient.asId("render_util");
        public static final List<class_2960> DEPENDENCIES = List.of(ResourceReloadListenerKeys.MODELS);
        private static final ReloadListener INSTANCE = new ReloadListener();

        public static void init() {
            ResourceManagerHelper.get((class_3264)class_3264.field_14188).registerReloadListener((IdentifiableResourceReloadListener)INSTANCE);
        }

        public void method_14491(class_3300 manager) {
            blockAtlasSpriteFinder = SpriteFinder.get((class_1059)MODEL_MANAGER.method_24153(class_1059.field_5275));
        }

        public class_2960 getFabricId() {
            return ID;
        }

        public Collection<class_2960> getFabricDependencies() {
            return DEPENDENCIES;
        }
    }
}

